"""
多路召回模块

包含以下召回算法：
- SwingRecall: Swing召回算法，基于物品相似度
- HotRecall: 热度召回算法，基于物品热度
- AdRecall: 广告召回算法，专门处理广告内容
- UserCFRecall: 用户协同过滤召回算法
- MultiRecallManager: 多路召回管理器，整合所有召回策略
"""

from .swing_recall import SwingRecall
from .hot_recall import HotRecall
from .ad_recall import AdRecall
from .usercf_recall import UserCFRecall
from .multi_recall_manager import MultiRecallManager

__all__ = [
    'SwingRecall',
    'HotRecall', 
    'AdRecall',
    'UserCFRecall',
    'MultiRecallManager'
]
