# Back-end Flask Project

## Overview
This project is a basic Flask application structure designed to demonstrate the organization of a Flask project. It includes essential components such as routes, models, templates, and configuration files.

## Project Structure
```
Back
├── app
│   ├── __init__.py
│   ├── routes.py
│   ├── models.py
│   └── templates
│       ├── base.html
│       └── index.html
├── tests
│   └── test_app.py
├── app.py
├── config.py
├── requirements.txt
└── README.md
```

## Setup Instructions

1. **Clone the repository**:
   ```
   git clone <repository-url>
   cd Back
   ```

2. **Create a virtual environment**:
   ```
   python -m venv venv
   ```

3. **Activate the virtual environment**:
   - On Windows:
     ```
     venv\Scripts\activate
     ```
   - On macOS/Linux:
     ```
     source venv/bin/activate
     ```

4. **Install dependencies**:
   ```
   pip install -r requirements.txt
   ```

5. **Run the application**:
   ```
   python app.py
   ```

## Usage
Once the application is running, you can access it at `http://127.0.0.1:5000/`. The index page will be displayed.

## Testing
To run the tests, ensure the virtual environment is activated and execute:
```
pytest tests/test_app.py
```

## Contributing
Feel free to submit issues or pull requests for improvements or bug fixes.

## License
This project is licensed under the MIT License.