from . import Base
from sqlalchemy import (
    Column, Integer, String, Enum, TIMESTAMP, text
)
from sqlalchemy.ext.declarative import declarative_base


class User(Base):
    __tablename__ = 'users'

    def to_dict(self):
        return {
            'id': self.id,
            'username': self.username if self.username else None,
            'email': self.email if self.email else None,
            'avatar': self.avatar if self.avatar else None,
            'role': self.role if self.role else None,
            'bio': self.bio if self.bio else None,
            'status': self.status if self.status else None,
            'created_at': self.created_at.isoformat() if self.created_at else None,
            'updated_at': self.updated_at.isoformat() if self.updated_at else None
        }



    id = Column(Integer, primary_key=True, autoincrement=True, comment='用户ID')
    username = Column(String(50), nullable=False, unique=True, comment='用户名')
    password = Column(String(255), nullable=False, comment='加密密码')
    email = Column(String(100), nullable=False, unique=True, comment='邮箱')
    avatar = Column(String(255), comment='头像URL')
    role = Column(Enum('user', 'admin', 'superadmin', name='user_role'), comment='角色')
    bio = Column(String(255), comment='个人简介')
    status = Column(
        Enum('active','banned','muted', name='user_status'),
        nullable=False,
        server_default=text("'active'"),
        comment='账号状态'
    )
    created_at = Column(
        TIMESTAMP,
        nullable=True,
        server_default=text('CURRENT_TIMESTAMP'),
        comment='创建时间'
    )
    updated_at = Column(
        TIMESTAMP,
        nullable=True,
        server_default=text('CURRENT_TIMESTAMP'),
        onupdate=text('CURRENT_TIMESTAMP'),
        comment='更新时间'
    )