const BASE = 'http://10.126.59.25:5713'  // 后端地址

/**
 * 获取待审核的帖子列表
 * POST /apostlist
 * @param {number|string} userId 平台管理员的用户 ID
 * @returns Promise<[ {id, title, status}, … ]>
 */
export async function fetchPosts(userId) {
  const res = await fetch(`${BASE}/apostlist`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ userid: userId })
  })
  if (!res.ok) throw new Error(`fetchPosts: ${res.status}`)
  
  const json = await res.json()
  console.log('fetchPosts response:', json)         // debug: inspect shape
  
  // normalize: if it's already an array use it; else pull array out of known keys
  const list = Array.isArray(json)
    ? json
    : json.data || json.posts || []
  
  return list
}

/**
 * 审核通过
 * POST /areview
 */
export async function approvePost(postId, userId) {
  const res = await fetch(`${BASE}/areview`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ userid: userId, postid: postId, status: 'published' })
  })
  if (!res.ok) throw new Error(`approvePost: ${res.status}`)
  return res.json()
}

/**
 * 驳回
 * POST /areview
 */
export async function rejectPost(postId, userId) {
  const res = await fetch(`${BASE}/areview`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ userid: userId, postid: postId, status: 'rejected' })
  })
  if (!res.ok) throw new Error(`rejectPost: ${res.status}`)
  return res.json()
}

/**
 * 获取单个帖子详情
 * POST /agetpost
 * @param {number|string} postId 帖子 ID
 * @param {number|string} userId 平台管理员的用户 ID
 * @returns Promise<{id, title, content, status}>
 */
export async function fetchPost(postId, userId) {
  const res = await fetch(`${BASE}/agetpost`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ userid: userId, postid: postId })
  })
  if (!res.ok) throw new Error(`fetchPost: ${res.status}`)
  return res.json()
}

/**
 * 获取超级管理员用户列表
 * POST /sgetuserlist
 * @param {number|string} userId 平台管理员的用户 ID
 * @returns Promise<[ {id, name, role}, … ]>
 */
export async function fetchUserList(userId) {
  const res = await fetch(`${BASE}/sgetuserlist`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ userid: userId })
  })
  if (!res.ok) throw new Error(`fetchUserList: ${res.status}`)
  return res.json()
}

export async function giveAdmin(userId, targetId) {
  const res = await fetch(`${BASE}/sgiveadmin`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ userid: userId, targetid: targetId })
  })
  if (!res.ok) throw new Error(`giveAdmin: ${res.status}`)
  return res.json()
}

export async function giveSuperAdmin(userId, targetId) {
  const res = await fetch(`${BASE}/sgivesuperadmin`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ userid: userId, targetid: targetId })
  })
  if (!res.ok) throw new Error(`giveSuperAdmin: ${res.status}`)
  return res.json()
}

export async function giveUser(userId, targetId) {
  const res = await fetch(`${BASE}/sgiveuser`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify({ userid: userId, targetid: targetId })
  })
  if (!res.ok) throw new Error(`giveUser: ${res.status}`)
  return res.json()
}