import React from 'react';
import { NavLink, Outlet } from 'react-router-dom';
import '../style/SuperAdmin.css';

export default function SuperAdmin() {
  const SUPERADMIN_USER_ID = 3;

  return (
    <div className="super-admin-container">
      <aside className="super-admin-sidebar">
        <h2>超级管理员</h2>
        <nav>
          <ul>
            <li>
              <NavLink 
                to="users" 
                end 
                className={({ isActive }) => isActive ? 'active' : ''}
              >
                用户管理
              </NavLink>
            </li>
            <li>
              <NavLink 
                to="dashboard" 
                className={({ isActive }) => isActive ? 'active' : ''}
              >
                平台运行监控
              </NavLink>
            </li>
          </ul>
        </nav>
      </aside>

      <main className="super-admin-content">
        <Outlet />
      </main>
    </div>
  );
}