import React from 'react';
import {
  Routes,
  Route,
  Navigate,
} from 'react-router-dom';
import AdminPage from '../components/Admin';
import UserManagement from '../components/UserManagement';
import LogsDashboard from '../components/LogsDashboard';
import SuperAdmin from '../components/SuperAdmin';

export default function App() {
  return (
    <Routes>
      <Route path="/" element={<Navigate to="admin" replace />} />

      {/* 普通管理员，无 header */}
      <Route path="admin" element={<AdminPage />} />

      {/* 超级管理员，只用 SuperAdminLayout */}
      <Route path="superadmin" element={<SuperAdmin />}>
        <Route index element={<Navigate to="users" replace />} />
        <Route path="users" element={<UserManagement superAdminId={3} />} />
        <Route path="dashboard" element={<LogsDashboard />} />
      </Route>
    </Routes>
  );
}