# utils/serializers.py
from marshmallow import Schema, fields, validate, ValidationError

class PostSchema(Schema):
    user_id = fields.Int(required=True)
    topic_id = fields.Int(required=False, allow_none=True)
    type = fields.Str(validate=validate.OneOf(['text','image','video','document']), missing='text')
    title = fields.Str(required=True, validate=validate.Length(min=1, max=255))
    content = fields.Str(required=True)
    media_urls = fields.List(fields.Url(), required=False)
    status = fields.Str(validate=validate.OneOf(['draft','pending','published','deleted','rejected']), missing='draft')

class CommentSchema(Schema):
    user_id = fields.Int(required=True)
    content = fields.Str(required=True, validate=validate.Length(min=1))
    parent_id = fields.Int(required=False, allow_none=True)
