# 小红书内容创作平台

这是一个基于 React + Vite 构建的小红书内容创作平台界面，完全复制了小红书官方创作服务平台的设计和功能。

## 功能特性 ✨

### 🎨 界面设计
- **完全还原小红书官方设计**：精确复制了小红书创作服务平台的视觉风格
- **响应式布局**：支持桌面端和移动端适配
- **现代化UI**：使用 Lucide React 图标库，提供清晰美观的界面

### 📤 上传功能
- **双模式上传**：支持图片上传和视频上传两种模式
- **拖拽上传**：支持文件拖拽到上传区域
- **点击上传**：点击按钮选择文件上传
- **文件验证**：
  - 图片：支持 JPEG、JPG、PNG、WebP 格式，最大 32MB
  - 视频：支持 MP4、MOV、AVI 格式，最大 2GB
- **实时进度显示**：带有动画效果的上传进度条

### 🖼️ 文件管理
- **文件预览**：上传后实时显示文件缩略图
- **文件信息**：显示文件名、大小等详细信息
- **批量管理**：支持单个删除和批量清除
- **文件计数**：实时显示已上传文件数量

### 🎯 交互体验
- **拖拽反馈**：拖拽时提供视觉反馈效果
- **加载状态**：上传过程中的加载动画
- **操作提示**：完成上传后的成功提示
- **悬停效果**：按钮和文件项的悬停交互

### 🗂️ 导航系统
- **侧边栏导航**：完整的功能菜单
- **可展开子菜单**：数据看板等功能的子选项
- **活跃状态**：当前选中页面的高亮显示
- **固定布局**：头部和侧边栏固定定位

## 技术栈 🛠️

- **前端框架**：React 19.1.0
- **构建工具**：Vite 6.0.5
- **图标库**：Lucide React 0.468.0
- **样式**：纯 CSS（无预处理器）
- **开发语言**：JavaScript + JSX

## 安装运行 🚀

1. **安装依赖**
   ```bash
   npm install
   ```

2. **启动开发服务器**
   ```bash
   npm run dev
   ```

3. **打开浏览器**
   ```
   http://localhost:5173
   ```

4. **构建生产版本**
   ```bash
   npm run build
   ```

## 项目结构 📁

```
发布页面/
├── public/              # 静态资源
│   └── vite.svg        # Vite 图标
├── src/
│   ├── App.jsx         # 主应用组件
│   ├── App.css         # 主样式文件
│   ├── index.css       # 全局样式
│   └── main.jsx        # 应用入口
├── index.html          # HTML 入口文件
├── package.json        # 项目配置
├── vite.config.js      # Vite 配置
└── README.md          # 项目说明
```

## 核心功能实现 💡

### 文件上传处理
```javascript
const handleFileUpload = () => {
  const input = document.createElement('input')
  input.type = 'file'
  input.accept = activeTab === 'video' ? 'video/*' : 'image/*'
  input.multiple = activeTab === 'image'
  
  input.onchange = (e) => {
    const files = Array.from(e.target.files)
    if (files.length > 0 && validateFiles(files)) {
      simulateUpload(files)
    }
  }
  
  input.click()
}
```

### 拖拽上传实现
```javascript
const handleDrop = (e) => {
  e.preventDefault()
  e.stopPropagation()
  setIsDragOver(false)
  
  const files = Array.from(e.dataTransfer.files)
  if (files.length > 0 && validateFiles(files)) {
    simulateUpload(files)
  }
}
```

### 文件验证机制
```javascript
const validateFiles = (files) => {
  const validImageTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/webp']
  const validVideoTypes = ['video/mp4', 'video/mov', 'video/avi']
  
  const validTypes = activeTab === 'video' ? validVideoTypes : validImageTypes
  const maxSize = activeTab === 'video' ? 2 * 1024 * 1024 * 1024 : 32 * 1024 * 1024
  
  return files.every(file => 
    validTypes.includes(file.type) && file.size <= maxSize
  )
}
```

## 样式特色 🎨

### 响应式设计
- 桌面端：固定侧边栏布局
- 移动端：隐藏侧边栏，堆叠布局
- 自适应文件网格：根据屏幕大小调整列数

### 动画效果
- 拖拽时的放大效果
- 进度条的流光动画
- 文件项的悬停过渡
- 页面切换的淡入效果

### 色彩方案
- 主色调：#ff4757（小红书红）
- 背景色：#f5f7fa（浅灰蓝）
- 文字色：#333（深灰）
- 边框色：#e8eaed（浅灰）

## 待扩展功能 🔮

- **后端集成**：连接真实的文件上传 API
- **用户认证**：登录注册功能
- **内容编辑**：笔记内容编辑器
- **数据统计**：真实的数据看板功能
- **社交功能**：评论、点赞等互动功能

## 开发说明 📝

这个项目完全基于前端实现，所有的上传功能都是模拟的。文件预览使用了 `URL.createObjectURL()` 来生成本地预览链接。在实际部署时，需要：

1. 集成后端文件上传 API
2. 实现用户认证系统
3. 添加数据持久化
4. 优化性能和安全性

## 浏览器兼容性 🌐

- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+

## 许可证 📄

MIT License

---

**注意**：本项目仅用于学习和演示目的，请遵守相关法律法规和平台使用条款。
