import React from 'react'
import {
  Home,
  BookOpen,
  Activity,
  Users
} from 'lucide-react'
import '../App.css' // 或 PlaceholderPage.css

const icons = {
  home: Home,
  notebooks: BookOpen,
  activity: Activity,
  notes: BookOpen,
  creator: Users,
  journal: BookOpen,
}

const titles = {
  home:      '欢迎来到小红书创作平台',
  notebooks: '笔记管理功能开发中',
  activity:  '活动中心功能开发中',
  notes:     '笔记灵感功能开发中',
  creator:   '创作学院功能开发中',
  journal:   '创作日刊功能开发中',
}

const descs = {
  home:      '在这里您可以管理您的创作内容，查看数据分析，获取创作灵感。',
  notebooks: '这里将显示您的所有笔记，支持编辑、删除、分类等操作。',
  activity:  '这里将展示最新的平台活动，让您参与更多有趣的创作活动。',
  notes:     '这里将为您提供创作灵感和写作建议，帮助您创作更好的内容。',
  creator:   '这里将提供创作技巧教学和平台规则说明，助您成为优秀创作者。',
  journal:   '这里将展示创作相关的最新资讯和平台动态。',
}

export default function PlaceholderPage({ pageId }) {
  const Icon = icons[pageId] || Home
  return (
    <div className="page-content">
      <div className="page-header">
        <h1 className="page-title">{titles[pageId]}</h1>
      </div>
      <div className="page-body">
        <div className="placeholder-content">
          <div className="placeholder-icon">
            <Icon size={48} />
          </div>
          <h3 className="placeholder-title">{titles[pageId]}</h3>
          <p className="placeholder-desc">{descs[pageId]}</p>
        </div>
      </div>
    </div>
  )
}