// src/router/index.jsx

import React from 'react'
import { Routes, Route, Navigate } from 'react-router-dom'
import CreatePost      from '../components/CreatePost'
import HomeFeed        from '../components/HomeFeed'
import NotebookPage    from '../components/NotebookPage'
import PlaceholderPage from '../components/PlaceholderPage'

export default function AppRouter() {
  return (
    <Routes>
      {/* 新帖 & 编辑帖（/:postId 可选） */}
      <Route path="/posts/new"           element={<CreatePost />} />
      <Route path="/posts/edit/:postId"  element={<CreatePost />} />

      <Route path="/home"      element={<HomeFeed />} />
      <Route path="/notebooks" element={<NotebookPage />} />
      <Route path="/activity"  element={<PlaceholderPage pageId="activity" />} />
      <Route path="/notes"     element={<PlaceholderPage pageId="notes" />} />
      <Route path="/creator"   element={<PlaceholderPage pageId="creator" />} />
      <Route path="/journal"   element={<PlaceholderPage pageId="journal" />} />

      <Route path="/dashboard/*" element={<PlaceholderPage />} />

      <Route path="/" element={<Navigate to="/dashboard/overview" replace />} />
      <Route path="*" element={<PlaceholderPage pageId="home" />} />
    </Routes>
  )
}
