# models/user.py

from datetime import datetime
from extensions import db

# 关联表：用户关注关系
follows = db.Table(
    'follows',
    db.Column('follower_id', db.Integer, db.ForeignKey('users.id', ondelete='CASCADE'), primary_key=True),
    db.Column('followee_id', db.Integer, db.ForeignKey('users.id', ondelete='CASCADE'), primary_key=True),
    db.Column('created_at', db.DateTime, default=datetime.utcnow, nullable=False)
)

class User(db.Model):
    __tablename__ = 'users'

    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String(50), unique=True, nullable=False)
    password = db.Column(db.String(255), nullable=False)
    email = db.Column(db.String(100), unique=True, nullable=False)
    avatar = db.Column(db.String(255))
    role = db.Column(db.Enum('user', 'admin'), default='user', nullable=False)
    bio = db.Column(db.String(255))
    status = db.Column(db.Enum('active', 'banned', 'muted'), default='active', nullable=False)
    created_at = db.Column(db.DateTime, default=datetime.utcnow, nullable=False)
    updated_at = db.Column(
        db.DateTime,
        default=datetime.utcnow,
        onupdate=datetime.utcnow,
        nullable=False
    )

    # 用户发布的帖子
    posts = db.relationship(
        'Post',
        backref='author',
        lazy='dynamic',
        cascade='all, delete-orphan'
    )

    # 用户的互动行为
    behaviors = db.relationship(
        'Behavior',
        backref='user',
        lazy='dynamic',
        cascade='all, delete-orphan'
    )

    # 用户发表的评论
    comments = db.relationship(
        'Comment',
        backref='user',
        lazy='dynamic',
        cascade='all, delete-orphan'
    )

    # 用户关注的对象列表
    following = db.relationship(
        'User',
        secondary=follows,
        primaryjoin=(id == follows.c.follower_id),
        secondaryjoin=(id == follows.c.followee_id),
        backref=db.backref('followers', lazy='dynamic'),
        lazy='dynamic'
    )

    def __repr__(self):
        return f"<User {self.username!r} id={self.id}>"
