# app.py

from flask import Flask
from flask_cors import CORS
from config import Config
from extensions import db, migrate

def create_app():
    app = Flask(__name__)
    app.config.from_object(Config)

    # 启用 CORS：允许前端 http://localhost:5173 发起跨域请求
    # 生产环境请根据实际域名调整 origins
    CORS(app, resources={
        r"/posts/*": {"origins": "http://localhost:5173"},
        r"/posts":   {"origins": "http://localhost:5173"}
    }, supports_credentials=True)

    db.init_app(app)
    migrate.init_app(app, db)

    # 在工厂函数里再导入并注册蓝图
    from routes.posts    import posts_bp
    from routes.comments import comments_bp

    app.register_blueprint(posts_bp,    url_prefix='/posts')
    app.register_blueprint(comments_bp, url_prefix='/posts/<int:post_id>/comments')

    return app

# 只有直接用 python app.py 时，这段才会执行
if __name__ == '__main__':
    app = create_app()
    app.run(host='0.0.0.0', port=5000, debug=True)
