# models/behavior.py
from extensions import db
from datetime import datetime

class Behavior(db.Model):
    __tablename__ = 'behaviors'

    id = db.Column(db.BigInteger, primary_key=True)
    user_id = db.Column(db.Integer, db.ForeignKey('users.id', ondelete='CASCADE'), nullable=False)
    post_id = db.Column(db.Integer, db.ForeignKey('posts.id', ondelete='CASCADE'), nullable=False)
    type = db.Column(db.Enum('like', 'comment', 'favorite', 'view', 'share'), nullable=False)
    value = db.Column(db.Integer, default=1, nullable=False)
    created_at = db.Column(db.DateTime, default=datetime.utcnow, nullable=False)
