from sqlalchemy import Column, Integer, String, DateTime, TIMESTAMP, Index
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.sql import func
from datetime import datetime

Base = declarative_base()

class Token(Base):
    __tablename__ = 'tokens'
    
    id = Column(Integer, primary_key=True, autoincrement=True)
    token = Column(String(255), nullable=False, unique=True)
    expires_at = Column(DateTime, nullable=False)
    created_at = Column(TIMESTAMP, default=func.current_timestamp())
    updated_at = Column(TIMESTAMP, default=func.current_timestamp(), onupdate=func.current_timestamp())
    
    __table_args__ = (
        Index('idx_token', 'token'),
        Index('idx_expires_at', 'expires_at'),
    )
    
    def __repr__(self):
        return f"<Token(id={self.id}, token='{self.token[:10]}...', expires_at={self.expires_at})>"
    
    def is_expired(self):
        """检查token是否已过期"""
        return datetime.now() > self.expires_at