from . import Base
from sqlalchemy import Column, Integer, String, Text, Enum, TIMESTAMP
from sqlalchemy.sql import func

class Topic(Base):
    __tablename__ = 'topics'
    __table_args__ = {
        'mysql_engine': 'InnoDB',
        'mysql_charset': 'utf8mb4',
        'mysql_collate': 'utf8mb4_general_ci',
        'comment': '话题/超话表'
    }

    id = Column(Integer, primary_key=True, autoincrement=True, comment='话题ID')
    name = Column(String(100, collation='utf8mb4_general_ci'), nullable=False, unique=True, comment='话题名称')
    description = Column(Text(collation='utf8mb4_general_ci'), comment='话题描述')
    status = Column(
        Enum('active', 'archived', name='topic_status', collation='utf8mb4_general_ci'),
        default='active',
        comment='状态'
    )
    created_at = Column(
        TIMESTAMP,
        server_default=func.current_timestamp(),
        comment='创建时间'
    )