import React from 'react';
import { Button, Modal } from 'antd';
import { LogoutOutlined } from '@ant-design/icons';
import { clearAuthInfo, getUserInfo } from '../../utils/auth';

const LogoutButton = ({ style = {}, onLogout = null }) => {
  const userInfo = getUserInfo();

  const handleLogout = () => {
    Modal.confirm({
      title: '确认退出',
      content: '您确定要退出登录吗？',
      okText: '确定',
      cancelText: '取消',
      onOk: () => {
        // 清除认证信息，但保留记住的登录信息
        clearAuthInfo(false);
        
        // 执行回调函数
        if (onLogout) {
          onLogout();
        } else {
          // 默认跳转到登录页
          window.location.href = '/';
        }
      }
    });
  };

  const handleCompleteLogout = () => {
    Modal.confirm({
      title: '完全退出',
      content: '这将清除所有保存的登录信息，包括"记住我"的设置。确定要继续吗？',
      okText: '确定',
      cancelText: '取消',
      onOk: () => {
        // 清除所有认证信息，包括记住的登录信息
        clearAuthInfo(true);
        
        // 执行回调函数
        if (onLogout) {
          onLogout();
        } else {
          // 默认跳转到登录页
          window.location.href = '/';
        }
      }
    });
  };

  if (!userInfo) {
    return null;
  }

  return (
    <div style={style}>
      <Button 
        type="default" 
        icon={<LogoutOutlined />}
        onClick={handleLogout}
        style={{ marginRight: 8 }}
      >
        退出登录
      </Button>
      <Button 
        type="link" 
        size="small"
        onClick={handleCompleteLogout}
        style={{ color: '#ff4d4f' }}
      >
        完全退出
      </Button>
    </div>
  );
};

export default LogoutButton;
