import React, { useEffect, useState } from 'react';
import '../style/Admin.css';

function LogsDashboard() {
  const [logs, setLogs] = useState([]);
  const [stats, setStats] = useState({});

  useEffect(() => {
    fetch('/api/logs')
      .then(res => res.json())
      .then(setLogs)
      .catch(console.error);
    fetch('/api/stats')
      .then(res => res.json())
      .then(setStats)
      .catch(console.error);
  }, []);

  return (
    <div className="admin-container">
      <h2>运行日志 & 性能 Dashboard</h2>
      <section className="dashboard-stats">
        <pre>{JSON.stringify(stats, null, 2)}</pre>
      </section>
      <section className="dashboard-logs">
        <table className="admin-table">
          <thead>
            <tr><th>时间</th><th>级别</th><th>消息</th></tr>
          </thead>
          <tbody>
            {logs.map((log, i) => (
              <tr key={i}>
                <td>{new Date(log.time).toLocaleString()}</td>
                <td>{log.level}</td>
                <td>{log.message}</td>
              </tr>
            ))}
          </tbody>
        </table>
      </section>
    </div>
  );
}

export default LogsDashboard;
