import React from 'react';
import { BrowserRouter, Routes, Route, Navigate, useParams } from 'react-router-dom';
import UserProfile from './components/UserProfile';
import { FaHome, FaSearch, FaPlus, FaHeart, FaUser } from 'react-icons/fa';

function App() {
  return (
    <BrowserRouter>
      <div className="min-h-screen bg-gray-50">
        {/* 顶部导航栏 */}
        <header className="bg-white shadow-sm sticky top-0 z-10">
          <div className="max-w-6xl mx-auto px-4 py-3 flex justify-between items-center">
            <div className="flex items-center">
              <div className="text-2xl font-bold text-red-500 mr-2">小红书</div>
              <div className="hidden md:block text-sm text-gray-500">发现美好生活</div>
            </div>
            <div className="flex space-x-4">
              <a href="/user/11" className="text-gray-600 hover:text-red-500">
                用户11
              </a>
              <a href="/user/2" className="text-gray-600 hover:text-red-500">
                用户2
              </a>
              <a href="/user/3" className="text-gray-600 hover:text-red-500">
                用户3
              </a>
            </div>
          </div>
        </header>

        <main className="py-5">
          <div className="max-w-6xl mx-auto">
            <Routes>
              <Route path="/" element={<Navigate to="/user/11" replace />} />
              <Route path="/user/:userId" element={<UserProfileRoute />} />
            </Routes>
          </div>
        </main>

        {/* 小红书风格底部导航栏 */}
        <div className="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 py-2 z-10">
          <div className="max-w-md mx-auto grid grid-cols-5">
            <button className="flex flex-col items-center text-red-500">
              <FaHome className="text-xl" />
              <span className="text-xs mt-1">首页</span>
            </button>
            <button className="flex flex-col items-center text-gray-500">
              <FaSearch className="text-xl" />
              <span className="text-xs mt-1">发现</span>
            </button>
            <button className="flex flex-col items-center text-gray-500">
              <div className="bg-red-500 rounded-full p-2 -mt-3">
                <FaPlus className="text-white text-lg" />
              </div>
              <span className="text-xs mt-2">发布</span>
            </button>
            <button className="flex flex-col items-center text-gray-500">
              <FaHeart className="text-xl" />
              <span className="text-xs mt-1">消息</span>
            </button>
            <button className="flex flex-col items-center text-gray-500">
              <FaUser className="text-xl" />
              <span className="text-xs mt-1">我</span>
            </button>
          </div>
        </div>
      </div>
    </BrowserRouter>
  );
}

function UserProfileRoute() {
  const { userId } = useParams();
  return <UserProfile userId={parseInt(userId)} />;
}

export default App;