import React, { useState } from 'react';
import { FaCamera, FaTimes } from 'react-icons/fa';

const EditProfileForm = ({ user, onSave, onCancel }) => {
  const [avatar, setAvatar] = useState(user.avatar || '');
  const [bio, setBio] = useState(user.bio || '');
  const [gender, setGender] = useState('secret');
  const [birthday, setBirthday] = useState('');
  const [location, setLocation] = useState('');

  const handleSubmit = (e) => {
    e.preventDefault();
    onSave({ avatar, bio });
  };

  return (
    <form onSubmit={handleSubmit}>
      <div className="mb-6">
        <label className="block text-sm font-medium text-gray-700 mb-2">头像</label>
        <div className="flex items-center">
          <div className="relative">
            <div className="w-20 h-20 rounded-full bg-gradient-to-r from-pink-300 to-orange-300 flex items-center justify-center">
              {avatar ? (
                <img src={avatar} alt="Avatar" className="w-full h-full rounded-full" />
              ) : (
                <div className="text-white text-2xl">{user.username.charAt(0)}</div>
              )}
            </div>
            <button 
              type="button"
              className="absolute bottom-0 right-0 bg-white rounded-full p-1 shadow-md"
            >
              <FaCamera className="text-gray-700 text-sm" />
            </button>
          </div>
          <div className="ml-4">
            <input
              type="text"
              value={avatar}
              onChange={(e) => setAvatar(e.target.value)}
              placeholder="输入头像URL"
              className="w-full rounded-md border-gray-300 shadow-sm text-sm"
            />
          </div>
        </div>
      </div>
      
      <div className="mb-4">
        <label className="block text-sm font-medium text-gray-700 mb-2">个人简介</label>
        <textarea
          value={bio}
          onChange={(e) => setBio(e.target.value)}
          rows="3"
          maxLength="100"
          className="mt-1 block w-full rounded-md border-gray-300 shadow-sm text-sm"
          placeholder="介绍一下自己吧～"
        />
        <div className="text-right text-xs text-gray-500 mt-1">{bio.length}/100</div>
      </div>
      
      <div className="grid grid-cols-2 gap-4 mb-4">
        <div>
          <label className="block text-sm font-medium text-gray-700 mb-2">性别</label>
          <select
            value={gender}
            onChange={(e) => setGender(e.target.value)}
            className="mt-1 block w-full rounded-md border-gray-300 shadow-sm text-sm"
          >
            <option value="secret">保密</option>
            <option value="male">男</option>
            <option value="female">女</option>
          </select>
        </div>
        
        <div>
          <label className="block text-sm font-medium text-gray-700 mb-2">生日</label>
          <input
            type="date"
            value={birthday}
            onChange={(e) => setBirthday(e.target.value)}
            className="mt-1 block w-full rounded-md border-gray-300 shadow-sm text-sm"
          />
        </div>
      </div>
      
      <div className="mb-6">
        <label className="block text-sm font-medium text-gray-700 mb-2">地区</label>
        <input
          type="text"
          value={location}
          onChange={(e) => setLocation(e.target.value)}
          placeholder="填写你所在的城市"
          className="mt-1 block w-full rounded-md border-gray-300 shadow-sm text-sm"
        />
      </div>
      
      <div className="flex justify-end space-x-3">
        <button 
          type="button"
          onClick={onCancel}
          className="px-5 py-2 bg-gray-100 text-gray-700 rounded-full text-sm hover:bg-gray-200"
        >
          取消
        </button>
        <button 
          type="submit"
          className="px-5 py-2 bg-red-500 text-white rounded-full text-sm hover:bg-red-600"
        >
          保存
        </button>
      </div>
    </form>
  );
};

export default EditProfileForm;