import React from 'react';
import { followUser, unfollowUser } from '../services/api';

const FollowButton = ({ userId, isFollowing, onFollowChange }) => {
  const handleFollow = async () => {
    try {
      if (isFollowing) {
        await unfollowUser(userId);
        onFollowChange(false);
      } else {
        await followUser(userId);
        onFollowChange(true);
      }
    } catch (error) {
      console.error('关注操作失败:', error);
    }
  };

  return (
    <button 
      onClick={handleFollow}
      className={`px-6 py-2 rounded-full text-sm font-medium transition-all ${
        isFollowing 
          ? 'bg-gray-100 text-gray-800 hover:bg-gray-200' 
          : 'bg-red-500 text-white hover:bg-red-600'
      }`}
    >
      {isFollowing ? '已关注' : '关注'}
    </button>
  );
};

export default FollowButton;