## 2. 帖子（Post）

### 2.1 发布新帖

```
POST /posts
```

- **描述**：创建一条帖子

- **请求头**

  ```
  Content-Type: application/json
  ```

- **请求体**

  ```json
  {
    "user_id": 1,
    "topic_id": 1,                    // 可选，必须是已存在 topic 的 ID
    "title": "帖子标题",
    "content": "正文内容",
    "media_urls": [                   // 可选，字符串数组
      "https://example.com/img1.jpg",
      "https://example.com/vid1.mp4"
    ],
    "status": "published"             // draft|pending|published|deleted|rejected
  }
  ```

- **成功响应**

  - **状态**：201 Created

  - **Body**

    ```json
    { "id": 42 }
    ```

- **错误**

  - 400 Bad Request: 缺少 user_id、title 或 content
  - 400 Bad Request: topic_id 不存在
  - 400 Bad Request: JSON 解析错误
  - 422 Unprocessable Entity: media_urls 格式错误
  - 500 Internal Server Error: 外键约束或其他数据库错误

------

### 2.2 获取帖子列表

```
GET /posts
```

- **描述**：拉取所有 `status=published` 的帖子

- **响应**

  - **状态**：200 OK

  - **Body**

    ```json
    [
      {
        "id": 42,
        "title": "帖子标题",
        "heat": 5,
        "created_at": "2025-06-12T16:00:00"
      },
      ...
    ]
    ```

------

### 2.3 查看帖子详情

```
GET /posts/{post_id}
```

- **描述**：查看单条帖子完整信息

- **路径参数**

  | 参数    | 描述    |
  | ------- | ------- |
  | post_id | 帖子 ID |

- **响应**

  - **状态**：200 OK

  - **Body**

    ```json
    {
      "id": 42,
      "user_id": 1,
      "topic_id": 1,
      "title": "帖子标题",
      "content": "正文内容",
      "media_urls": ["…"],
      "status": "published",
      "heat": 5,
      "created_at": "2025-06-12T16:00:00",
      "updated_at": "2025-06-12T16:05:00"
    }
    ```

- **错误**

  - 404 Not Found: 帖子不存在

------

### 2.4 修改帖子

```
PUT /posts/{post_id}
```

- **描述**：更新帖子字段

- **路径参数**

  | 参数    | 描述    |
  | ------- | ------- |
  | post_id | 帖子 ID |

- **请求头**

  ```
  Content-Type: application/json
  ```

- **请求体**（所有字段可选，依需更新）

  ```json
  {
    "title": "新标题",
    "content": "新内容",
    "topic_id": 2,
    "media_urls": ["…"],
    "status": "draft"
  }
  ```

- **响应**

  - **状态**：204 No Content

- **错误**

  - 400 Bad Request: JSON 格式或字段值不合法
  - 404 Not Found: 帖子不存在

------

### 2.5 删除帖子

```
DELETE /posts/{post_id}
```

- **描述**：删除帖子及其关联行为、评论

- **路径参数**

  | 参数    | 描述    |
  | ------- | ------- |
  | post_id | 帖子 ID |

- **响应**

  - **状态**：204 No Content

- **错误**

  - 404 Not Found: 帖子不存在

------

## 3. 互动行为（Behavior）

> 支持四种操作：`like`、`favorite`、`view`、`share`。其中 `like` 和 `favorite` 限制每人每帖最多一次，可撤销；`view`/`share` 不限次数，不提供撤销。

### 3.1 点赞

```
POST /posts/{post_id}/like
```

- **描述**：用户点赞，热度 +1

- **请求头**

  ```
  Content-Type: application/json
  ```

- **请求体**

  ```json
  { "user_id": 1 }
  ```

- **响应**

  - **状态**：201 Created

- **错误**

  - 400 Bad Request: 已点赞过 → `{"error":"already liked"}`
  - 400 Bad Request: 缺少 user_id
  - 404 Not Found: 帖子或用户不存在

### 3.2 取消点赞

```
DELETE /posts/{post_id}/like
```

- **描述**：撤销点赞，热度 -1（底线 0）

- **请求头**

  ```
  Content-Type: application/json
  ```

- **请求体**

  ```json
  { "user_id": 1 }
  ```

- **响应**

  - **状态**：204 No Content

- **错误**

  - 400 Bad Request: 未点赞过 → `{"error":"not liked yet"}`
  - 404 Not Found: 帖子或用户不存在

------

### 3.3 收藏

```
POST /posts/{post_id}/favorite
```

- **描述**：用户收藏，热度 +1
- **请求头/体/响应/错误**
   与点赞接口完全一致，只把 `like` 换成 `favorite`，错误信息为 `already favorited` / `not favorited yet`。

### 3.4 取消收藏

```
DELETE /posts/{post_id}/favorite
```

- **描述**：撤销收藏，热度 -1
- **请求头/体/响应/错误**
   同上。

------

### 3.5 浏览

```
POST /posts/{post_id}/view
```

- **描述**：记录一次浏览，热度 +1

- **请求体**

  ```json
  { "user_id": 1 }
  ```

- **响应**

  - 201 Created

不支持撤销；不做去重检查。

------

### 3.6 分享

```
POST /posts/{post_id}/share
```

- **描述**：记录一次分享，热度 +1
- **请求体/响应**
   同浏览。

------

## 4. 评论（Comment）

### 4.1 添加评论

```
POST /posts/{post_id}/comments
```

- **描述**：为帖子添加评论或回复

- **请求头**

  ```
  Content-Type: application/json
  ```

- **请求体**

  ```json
  {
    "user_id": 2,
    "content": "这是评论内容",
    "parent_id": 1    // 可选：回复某条评论时填，一级评论则省略
  }
  ```

- **响应**

  - **状态**：201 Created

  - **Body**

    ```json
    { "id": 7 }
    ```

- **错误**

  - 400 Bad Request: 缺少 user_id 或 content
  - 404 Not Found: 帖子或 parent_id 不存在

------

### 4.2 获取评论列表

```
GET /posts/{post_id}/comments
```

- **描述**：拉取该帖所有一级评论及其完整回复树

- **响应**

  - **状态**：200 OK

  - **Body**

    ```json
    [
      {
        "id": 1,
        "user_id": 1,
        "content": "一级评论",
        "created_at": "…",
        "replies": [
          {
            "id": 2,
            "user_id": 2,
            "content": "回复评论",
            "created_at": "…",
            "replies": [ … ]
          }
        ]
      },
      …
    ]
    ```

- **错误**

  - 404 Not Found: 帖子不存在

------

> **通用错误响应格式**
>
> ```json
> {
>   "error": "描述信息"
> }
> ```