// src/router/index.jsx
import React from 'react'
import { Routes, Route, Navigate } from 'react-router-dom'

// 确认这些路径和文件名与你项目里是一一对应的
import CreatePost     from '../components/CreatePost'      // src/components/CreatePost.jsx
import HomeFeed       from '../components/HomeFeed'        // src/components/HomeFeed.jsx
import PlaceholderPage from '../components/PlaceholderPage'// src/components/PlaceholderPage.jsx
import UploadPage     from '../components/UploadPage'      // src/components/UploadPage.jsx

export default function AppRouter() {
  return (
    <Routes>
      {/* 一定要放在最前面，防止被 /* 等 catch-all 覆盖 */}
      <Route path="/posts/new" element={<CreatePost />} />

      <Route path="/home"      element={<HomeFeed />} />

      <Route path="/notebooks" element={<PlaceholderPage pageId="notebooks" />} />
      <Route path="/activity"  element={<PlaceholderPage pageId="activity"  />} />
      <Route path="/notes"     element={<PlaceholderPage pageId="notes"     />} />
      <Route path="/creator"   element={<PlaceholderPage pageId="creator"   />} />
      <Route path="/journal"   element={<PlaceholderPage pageId="journal"   />} />

      <Route path="/dashboard/*" element={<UploadPage />} />

      {/* 根路径重定向到 dashboard */}
      <Route path="/" element={<Navigate to="/dashboard/overview" replace />} />

      {/* 最后一个兜底 */}
      <Route path="*" element={<PlaceholderPage pageId="home" />} />
    </Routes>
  )
}
