import axios from 'axios';

const api = axios.create({
  baseURL: 'http://localhost:5000/api',
  withCredentials: true
});

// 用户相关API
export const getCurrentUser = () => api.get('/current-user');
export const getUser = (userId) => api.get(`/user/${userId}`);
export const updateUser = (userId, data) => api.put(`/user/${userId}`, data);

// 收藏相关API
export const getFavorites = (userId) => api.get(`/user/${userId}/favorites`);

// 关注相关API
export const followUser = (followeeId) => api.post(`/follow/${followeeId}`);
export const unfollowUser = (followeeId) => api.delete(`/follow/${followeeId}`);

// 帖子相关API
export const getUserPosts = (userId) => api.get(`/user/${userId}/posts`);

// 关注列表API
export const getUserFollowing = (userId) => api.get(`/user/${userId}/following`);

// 用户互动数据API
export const getUserInteractions = (userId) => api.get(`/user/${userId}/interactions`);
// 获取粉丝
export const getUserFollowers = (userId) => api.get(`/user/${userId}/followers`);

export default api;