import React from "react";
import { BrowserRouter as Router } from "react-router-dom";
import { AuthProvider } from "./features/auth/contexts/AuthContext";
import AppRoutes from "./routes"; // 您的主路由组件
// 如果您在 main.jsx 中没有使用 Antd 的 App 组件，且需要ConfigProvider
// import { ConfigProvider, App as AntApp } from 'antd';
// import antdThemeConfig from './config/antdTheme'; // 假设有主题配置

function App() {
  return (
    // <ConfigProvider theme={antdThemeConfig}> {/* 如果有主题配置 */}
    //   <AntApp> {/* 如果在 main.jsx 中未使用，可以在这里包裹 */}
    <Router>
      <AuthProvider>
        <AppRoutes />
      </AuthProvider>
    </Router>
    //   </AntApp>
    // </ConfigProvider>
  );
}

export default App;
