import request from "@/utils/request";

// 用户认证相关API
export const userLogin = (params) => {
  return request.post("/user/login", {...params});
};

export const adminLogin = (params) => {
  return request.post("/admin/login", {...params});
};

export const registerUser = (params) => {
  return request.post("/user/register", {...params});
};

export const updateUsername = (params) => {
  return request.post("/user/update/username", {...params});
};

export const updatePassword = (params) => {
  return request.post("/user/update/password", {...params});
};

export const updateEmail = (params) => {
  return request.post("/user/update/email", {...params});
};

export const getUserList = (params) => {
  return request.get('/user/list', {params});
};

export const deleteUser = (params) => {
  return request.delete("/user/delete", {params});
};

export const logoutUser = () => {
  // 清除本地存储
  localStorage.removeItem("token");
  localStorage.removeItem("user");

  return Promise.resolve({
    success: true,
    message: "注销成功",
  });
}; 