import request from "@/utils/request";

// 帖子相关API
export const createPost = (params) => {
  return request.post("/posts/create", {...params});
};

export const getPosts = (params) => {
  return request.get("/posts/list", {params});
};

export const deletePost = (username, pid) => {
  return request.delete("/posts/delete", {
    data: { username, pid },
  });
};

// 评论相关API
export const addComment = (params) => {
  return request.post("/comment/add", {...params});
};

export const getComments = (params) => {
  return request.get('/comment/get', {params});
};

export const deleteComment = (username, commentId) => {
  return request.delete("/comment/delete", {
    data: { username, commentId },
  });
}; 