import request from "@/utils/request";

// 用户资料相关API
export const getUserProfile = (username) => {
  return request.get(`/user/profile/${username}`);
};

export const updateUserProfile = (userData) => {
  return request.put("/user/profile", userData);
};

export const uploadAvatar = (formData) => {
  return request.post("/user/avatar", formData, {
    headers: {
      'Content-Type': 'multipart/form-data',
    },
  });
};

// PT站统计信息API
export const getUserStats = (username) => {
  return request.get(`/user/stats/${username}`);
};

export const getUserTorrents = (username, type = 'all') => {
  return request.get(`/user/torrents/${username}`, {
    params: { type } // type: 'seeding', 'leeching', 'completed', 'all'
  });
};

export const getUserHistory = (username, page = 1, limit = 10) => {
  return request.get(`/user/history/${username}`, {
    params: { page, limit }
  });
}; 