import React from 'react';
import { Button, Divider, List, Typography, Space, Tag } from 'antd';
import { CloudDownloadOutlined } from '@ant-design/icons';

const { Title, Paragraph, Text } = Typography;

const HomePage = () => (
  <div className="space-y-6">
    <div className="text-center py-8">
      <Title level={1}>欢迎来到 PT 网站</Title>
      <Paragraph className="text-lg text-slate-500">
        高清资源分享，互助共赢的PT资源社区
      </Paragraph>
      <Button type="primary" size="large" icon={<CloudDownloadOutlined />}>
        浏览资源
      </Button>
    </div>
    
    <Divider>最新公告</Divider>
    
    <List
      itemLayout="horizontal"
      dataSource={[
        {
          title: '网站升级通知',
          date: '2023-06-15',
          content: '网站将于本周六进行系统升级，届时将暂停服务4小时。'
        },
        {
          title: '新规则发布',
          date: '2023-06-10',
          content: '关于发布资源的新规则已经生效，请会员查看详情。'
        },
        {
          title: '新用户注册开放',
          date: '2023-06-01',
          content: '本站现已开放新用户注册，每天限额100名。'
        }
      ]}
      renderItem={(item) => (
        <List.Item>
          <List.Item.Meta
            title={<Space><Text strong>{item.title}</Text><Tag color="blue">{item.date}</Tag></Space>}
            description={item.content}
          />
        </List.Item>
      )}
    />
  </div>
);

export default HomePage; 