import React from 'react';
import { Card, Typography, Button } from 'antd';
import { ToolOutlined, CloudDownloadOutlined, AppstoreOutlined } from '@ant-design/icons';

const { Title, Paragraph } = Typography;

const ToolsPage = () => (
  <div className="space-y-6">
    <Title level={2}>工具箱</Title>
    <Paragraph className="text-slate-500">
      这里提供了一些有用的PT相关工具和资源。
    </Paragraph>
    
    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
      <Card 
        title="分享率计算器" 
        extra={<ToolOutlined />}
        className="shadow-sm hover:shadow-md transition-shadow"
      >
        <p>计算所需上传量以达到目标分享率。</p>
        <Button type="link" className="mt-2">使用工具</Button>
      </Card>
      
      <Card 
        title="批量下载工具" 
        extra={<CloudDownloadOutlined />}
        className="shadow-sm hover:shadow-md transition-shadow"
      >
        <p>一键下载多个种子文件。</p>
        <Button type="link" className="mt-2">使用工具</Button>
      </Card>
      
      <Card 
        title="MediaInfo 解析器" 
        extra={<AppstoreOutlined />}
        className="shadow-sm hover:shadow-md transition-shadow"
      >
        <p>解析并美化展示MediaInfo信息。</p>
        <Button type="link" className="mt-2">使用工具</Button>
      </Card>
    </div>
  </div>
);

export default ToolsPage; 