import React from 'react';
import { Routes, Route, Navigate } from 'react-router-dom';

// 导入布局
import MainLayout from '../layouts/MainLayout';

// 导入页面
import LoginPage from '../features/auth/pages/LoginPage';
import RegisterPage from '../features/auth/pages/RegisterPage';
import AdminPanel from '../features/admin/pages/AdminPanel';
import NotFoundPage from '../pages/NotFoundPage';
import UnauthorizedPage from '../pages/UnauthorizedPage';

// 导入新创建的页面组件
import HomePage from '../features/home/pages/HomePage';
import ForumPage from '../features/forum/pages/ForumPage';
import PostDetailPage from '../features/forum/pages/PostDetailPage';
import PTPage from '../features/pt/pages/PTPage';
import TorrentListPage from '../features/torrents/pages/TorrentListPage';
import UploadTorrentPage from '../features/torrents/pages/UploadTorrentPage';
import ToolsPage from '../features/tools/pages/ToolsPage';
import ProfilePage from '../features/profile/pages/ProfilePage';

// 导入路由守卫
import ProtectedRoute from './ProtectedRoute';
import PermissionRoute from './PermissionRoute';

const AppRoutes = () => {
  return (
    <Routes>
      {/* 公共路由 */}
      <Route path="/login" element={<LoginPage />} />
      <Route path="/register" element={<RegisterPage />} />
      <Route path="/unauthorized" element={<UnauthorizedPage />} />
      <Route path="*" element={<NotFoundPage />} />

      {/* 受保护的路由 (需要登录) */}
      <Route 
        path="/" 
        element={
          <ProtectedRoute>
            <MainLayout>
              <HomePage />
            </MainLayout>
          </ProtectedRoute>
        } 
      />
      
      <Route 
        path="/forum" 
        element={
          <ProtectedRoute>
            <MainLayout>
              <ForumPage />
            </MainLayout>
          </ProtectedRoute>
        } 
      />
      
      <Route 
        path="/post/:postId" 
        element={
          <ProtectedRoute>
            <MainLayout>
              <PostDetailPage />
            </MainLayout>
          </ProtectedRoute>
        } 
      />
      
      <Route 
        path="/pt" 
        element={
          <ProtectedRoute>
            <MainLayout>
              <PTPage />
            </MainLayout>
          </ProtectedRoute>
        } 
      />
      
      <Route 
        path="/torrents" 
        element={
          <ProtectedRoute>
            <MainLayout>
              <TorrentListPage />
            </MainLayout>
          </ProtectedRoute>
        } 
      />
      
      <Route 
        path="/upload" 
        element={
          <ProtectedRoute>
            <MainLayout>
              <UploadTorrentPage />
            </MainLayout>
          </ProtectedRoute>
        } 
      />
      
      <Route 
        path="/tools" 
        element={
          <ProtectedRoute>
            <MainLayout>
              <ToolsPage />
            </MainLayout>
          </ProtectedRoute>
        } 
      />
      
      <Route 
        path="/profile" 
        element={
          <ProtectedRoute>
            <MainLayout>
              <ProfilePage />
            </MainLayout>
          </ProtectedRoute>
        } 
      />
      
      <Route
        path="/admin"
        element={
          <ProtectedRoute>
            <PermissionRoute requiredRoles={['admin']}> 
              <MainLayout>
                <AdminPanel />
              </MainLayout>
            </PermissionRoute>
          </ProtectedRoute>
        }
      />
    </Routes>
  );
};

export default AppRoutes;