import request from "../../../services/request";

// 帖子相关API
export const createPost = (postData) => {
  const token = localStorage.getItem("token");
  return request
    .post(
      "/posts/create", 
      postData, 
      { headers: { token } }
    )
    .then((response) => {
      if (response.data && response.data.success) {
        return response.data;
      } else {
        return Promise.reject(new Error(response.data.message || "创建帖子失败"));
      }
    });
};

export const getPosts = (filters) => {
  const token = localStorage.getItem("token");
  
  // 构建查询参数
  let queryParams = new URLSearchParams();
  if (filters) {
    if (filters.username) queryParams.append("username", filters.username);
    if (filters.title) queryParams.append("title", filters.title);
    if (filters.author) queryParams.append("author", filters.author);
    if (filters.date) queryParams.append("date", filters.date);
  }
  
  return request
    .get(
      `/posts/list?${queryParams.toString()}`, 
      { headers: { token } }
    )
    .then((response) => {
      if (response.data && response.data.success) {
        return response.data;
      } else {
        return Promise.reject(new Error(response.data.message || "获取帖子列表失败"));
      }
    });
};

export const deletePost = (username, pid) => {
  const token = localStorage.getItem("token");
  return request
    .delete(
      "/posts/delete", 
      { 
        headers: { token },
        data: { username, pid }
      }
    )
    .then((response) => {
      if (response.data && response.data.success) {
        return response.data;
      } else {
        return Promise.reject(new Error(response.data.message || "删除帖子失败"));
      }
    });
};

// 评论相关API
export const addComment = (commentData) => {
  const token = localStorage.getItem("token");
  return request
    .post(
      "/comment/add", 
      commentData, 
      { headers: { token } }
    )
    .then((response) => {
      if (response.data && response.data.success) {
        return response.data;
      } else {
        return Promise.reject(new Error(response.data.message || "添加评论失败"));
      }
    });
};

export const getComments = (postId, username) => {
  const token = localStorage.getItem("token");
  return request
    .get(
      `/comment/get?postId=${postId}&username=${username}`, 
      { headers: { token } }
    )
    .then((response) => {
      if (response.data && response.data.success) {
        return response.data;
      } else {
        return Promise.reject(new Error(response.data.message || "获取评论失败"));
      }
    });
};

export const deleteComment = (username, commentId) => {
  const token = localStorage.getItem("token");
  return request
    .delete(
      "/comment/delete", 
      { 
        headers: { token },
        data: { username, commentId }
      }
    )
    .then((response) => {
      if (response.data && response.data.success) {
        return response.data;
      } else {
        return Promise.reject(new Error(response.data.message || "删除评论失败"));
      }
    });
}; 