import React from "react";
import { Navigate, useLocation } from "react-router-dom";
import { useAuth } from "../features/auth/contexts/AuthContext"; // 更新路径
import { Spin, Result, Button } from "antd";

const PermissionRoute = ({ children, requiredRoles }) => {
  const { user, isAuthenticated, loading, hasRole } = useAuth();
  const location = useLocation();

  if (loading) {
    return (
      <div className="flex justify-center items-center min-h-screen">
        <Spin size="large" tip="检查权限中..." />
      </div>
    );
  }

  if (!isAuthenticated) {
    return <Navigate to="/login" state={{ from: location }} replace />;
  }

  // 角色检查
  const hasRequiredRoles = requiredRoles
    ? requiredRoles.some((role) => hasRole(role)) // 满足任一角色即可
    : true; // 如果没有指定 requiredRoles，则认为通过

  if (hasRequiredRoles) {
    return children; // 用户有权限，渲染子组件
  }

  // 用户无权限
  return (
    <Result
      status="403"
      title="403 - 禁止访问"
      subTitle="抱歉，您没有权限访问此页面。"
      extra={
        <Button type="primary" onClick={() => window.history.back()}>
          返回上一页
        </Button>
      }
    />
  );
  // 或者重定向到 /unauthorized 页面
  // return <Navigate to="/unauthorized" state={{ from: location }} replace />;
};

export default PermissionRoute;
