import React from 'react';
import { Card, Typography, Space } from 'antd';

const { Title, Paragraph } = Typography;

const PTPage = () => (
  <div className="space-y-6">
    <Title level={2}>PT 系统说明</Title>
    <Card className="shadow-sm">
      <Space direction="vertical" size="large" style={{ width: '100%' }}>
        <div>
          <Title level={4}>什么是PT？</Title>
          <Paragraph>
            Private Tracker (PT) 是一种私人的BitTorrent追踪器，只允许注册用户访问和使用。PT站点通常会记录用户的上传和下载量，以维护良好的分享率。
          </Paragraph>
        </div>
        
        <div>
          <Title level={4}>分享率规则</Title>
          <Paragraph>
            分享率 = 总上传量 ÷ 总下载量。新用户需要保持不低于0.4的分享率。长期保持优秀分享率的用户将获得额外权益。
          </Paragraph>
        </div>
        
        <div>
          <Title level={4}>邀请制度</Title>
          <Paragraph>
            达到以下条件的用户可以获得邀请资格：
          </Paragraph>
          <ul>
            <li>注册时间超过3个月</li>
            <li>分享率大于1.0</li>
            <li>上传量超过50GB</li>
          </ul>
        </div>
      </Space>
    </Card>
  </div>
);

export default PTPage; 