package com.pt.entity;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;

import java.time.LocalDateTime;

@Entity
public class Download {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private int downloadId;

    private String resourceId;
    private String downloader;
    private LocalDateTime downloadTime;

    public Download() {
    }

    public Download(int downloadId, String resourceId, String downloader, LocalDateTime downloadTime) {
        this.downloadId = downloadId;
        this.resourceId = resourceId;
        this.downloader = downloader;
        this.downloadTime = downloadTime;
    }

    public int getDownloadId() {
        return downloadId;
    }
    public void setDownloadId(int downloadId) {
        this.downloadId = downloadId;
    }
    public String getResourceId() {
        return resourceId;
    }
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }
    public String getDownloader() {
        return downloader;
    }
    public void setDownloader(String downloader) {
        this.downloader = downloader;
    }
    public LocalDateTime getDownloadTime() {
        return downloadTime;
    }
    public void setDownloadTime(LocalDateTime downloadTime) {
        this.downloadTime = downloadTime;
    }
}
