package com.pt.repository;

import com.pt.entity.Comment;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

public interface CommentRepository extends JpaRepository<Comment, Integer> {
    Comment findByContent(String content);

    Comment findByWriter(String writer);

    @Query(value = "SELECT c FROM Comment c WHERE c.writer = :writer")
    List<Comment> listByWriter(@Param("writer") String writer);

    @Query(value = "SELECT c FROM Comment c WHERE c.publishDate = :date")
    List<Comment> listByDate(@Param("date") LocalDateTime date);

    List<Comment> findByParentPost(int parentPost);
}
