package com.pt.controller;

import com.pt.service.TrackerService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.Map;

@RestController
public class TrackerController {

    @Autowired
    private TrackerService trackerService;

    @GetMapping("/announce")
    public void announce(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String ip = request.getRemoteAddr();
            Map<String, String[]> params = request.getParameterMap();

            byte[] bencodedResponse = trackerService.handleAnnounce(params, ip);

            response.setContentType("application/x-bittorrent");
            response.getOutputStream().write(bencodedResponse);
        } catch (Exception e) {
            response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
            response.setContentType("text/plain");
            response.getWriter().write("Tracker internal error: " + e.getMessage());
        }
    }

}

