package com.pt.repository;

import com.pt.entity.PeerInfoEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

public interface PeerInfoRepository extends JpaRepository<PeerInfoEntity, Long> {
    List<PeerInfoEntity> findByInfoHash(String infoHash);

    // 根据 peerId 和 infoHash 查找
    Optional<PeerInfoEntity> findByPeerIdAndInfoHash(String peerId, String infoHash);

    // 获取活跃的 peer
    @Query("SELECT p FROM PeerInfoEntity p WHERE p.infoHash = :infoHash AND p.isActive = true")
    List<PeerInfoEntity> findActivePeersByInfoHash(String infoHash);

    // 获取需要清理的非活跃 peer
    @Query("SELECT p FROM PeerInfoEntity p WHERE p.lastSeen < :threshold")
    List<PeerInfoEntity> findInactivePeers(LocalDateTime threshold);
}
