package com.pt.repository;

import com.pt.entity.Post;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

public interface PostRepository extends JpaRepository<Post, Integer> {
    Post findByTitle(String title);

    Post findByAuthor(String author);

    @Query(value = "SELECT p FROM Post p WHERE p.author = :author")
    List<Post> listByAuthor(String author);

    @Query(value = "SELECT p FROM Post p WHERE p.title LIKE :title%")
    List<Post> listByTitle(@Param("title") String title);

    @Query(value = "SELECT p FROM Post p WHERE p.publishDate = :date")
    List<Post> listByDate(@Param("date") LocalDate date);
}
