package com.pt.service;

import com.pt.entity.Comment;
import com.pt.repository.CommentRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CommentService {

    @Autowired
    private CommentRepository commentRepository;

    public CommentService(CommentRepository commentRepository) {
        this.commentRepository = commentRepository;
    }

    public void addComment(String content, String username, int postId) {
        Comment comment = new Comment();
        comment.setContent(content);
        comment.setWriter(username);
        comment.setParentPost(postId);
        commentRepository.save(comment);
    }

    public void deleteComment(int commentId) {
        commentRepository.deleteById(commentId);
    }

    public List<Comment> getCommentsByPostId(int postId) {
        List<Comment> comments = commentRepository.findByParentPost(postId);
        comments.sort(
                // Sort comments by publish date in descending order
                (c1, c2) -> c2.getPublishDate().compareTo(c1.getPublishDate())
        );
        return comments;
    }
}
