package com.pt.service;

import com.pt.entity.Post;
import com.pt.repository.PostRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.List;

@Service
public class PostService {

    @Autowired
    private PostRepository postRepository;

    public void createPost(String title, String content, String author) {
        System.out.println("Post created with title: " + title);
        postRepository.save(new Post(title, content, author));
    }

    public Post findPostByTitle(String title) {
        return postRepository.findByTitle(title);
    }

    public List<Post> listByAuthor(String author) {
        return postRepository.listByAuthor(author);
    }

    public List<Post> listByTitle(String title) {
        return postRepository.listByTitle(title);
    }

    public List<Post> listByDate(String date) {
        LocalDate nDate  = LocalDate.parse(date);
        return postRepository.listByDate(nDate);
    }

    public List<Post> listAll() {
        return postRepository.findAll();
    }

    public void deletePost(Post p) {
        postRepository.delete(p);
    }

    public Post findPostById(int id) {
        return postRepository.findById(id).orElse(null);
    }
}
