package com.pt.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import com.pt.entity.User;
import com.pt.service.UserService;

@RestController
@RequestMapping("/api/user")
@CrossOrigin(origins = "*")
public class UserController {

    @Autowired
    private UserService userService;

    @PostMapping("/register")
    public ResponseEntity<?> registerUser(@RequestParam("username") String username,
                                          @RequestParam("password") String password,
                                          @RequestParam("email") String email) {
        User user = userService.findByUsername(username);
        if (user != null) {
            return ResponseEntity.badRequest().body("User already exists");
        } else {
            User newUser = new User();

            String uid = String.valueOf(System.currentTimeMillis());
            newUser.setUid(uid);
            newUser.setUsername(username);
            newUser.setPassword(password);
            newUser.setEmail(email);
            userService.save(newUser);
            return ResponseEntity.ok("User registered successfully");
        }
    }

    @PostMapping("/login")
    public ResponseEntity<?> loginUser(@RequestParam("username") String username,
                                       @RequestParam("password") String password) {
        User user = userService.findByUsernameAndPassword(username, password);
        if (user != null) {
            return ResponseEntity.ok("Login successful");
        } else {
            return ResponseEntity.badRequest().body("Invalid username or password");
        }
    }

    @PostMapping("/update/username")
    public ResponseEntity<?> updateUsername(@RequestParam("username") String oldUsername,
                                            @RequestParam("newUsername") String newUsername) {
        User user = userService.findByUsername(oldUsername);
        if (user != null) {
            user.setUsername(newUsername);
            userService.save(user);
            return ResponseEntity.ok("Username updated successfully");
        } else {
            return ResponseEntity.badRequest().body("User not found");
        }
    }

    @PostMapping("/update/password")
    public ResponseEntity<?> updatePassword(@RequestParam("username") String username,
                                            @RequestParam("newPassword") String newPassword) {
        User user = userService.findByUsername(username);
        if (user != null) {
            user.setPassword(newPassword);
            userService.save(user);
            return ResponseEntity.ok("Password updated successfully");
        } else {
            return ResponseEntity.badRequest().body("Invalid username or password");
        }
    }

    @PostMapping("/update/email")
    public ResponseEntity<?> updateEmail(@RequestParam("username") String username,
                                         @RequestParam("newEmail") String newEmail) {
        User user = userService.findByUsername(username);
        if (user != null) {
            user.setEmail(newEmail);
            userService.save(user);
            return ResponseEntity.ok("Email updated successfully");
        } else {
            return ResponseEntity.badRequest().body("User not found");
        }
    }
}
