package com.pt.repository;

import com.pt.entity.Download;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

public interface DownloadRepository extends JpaRepository<Download, Integer> {
    /**
     * Finds downloads by the resource ID.
     *
     * @param resourceId the ID of the resource
     * @return a list of downloads associated with the specified resource
     */
    List<Download> findByResourceId(String resourceId);

    /**
     * Finds downloads by the downloader's username.
     *
     * @param downloader the username of the downloader
     * @return a list of downloads made by the specified user
     */
    List<Download> findByDownloader(String downloader);
}
