package com.pt.Item;

import java.time.LocalDateTime;

public class ResourceInfo {

    private int resourceId;

    private String name;
    private double size;

    private LocalDateTime publishTime;
    private String author;

    private String description;

    private int seedCount;
    private int downloadCount;

    public ResourceInfo() {
    }

    public ResourceInfo(int resourceId, String name, double size, LocalDateTime publishTime, String author) {
        this.resourceId = resourceId;
        this.name = name;
        this.size = size;
        this.publishTime = publishTime;
        this.author = author;
    }

    public int getResourceId() {
        return resourceId;
    }
    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public double getSize() {
        return size;
    }
    public void setSize(double size) {
        this.size = size;
    }
    public LocalDateTime getPublishTime() {
        return publishTime;
    }
    public void setPublishTime(LocalDateTime publishTime) {
        this.publishTime = publishTime;
    }
    public String getAuthor() {
        return author;
    }
    public void setAuthor(String author) {
        this.author = author;
    }
    public String getDescription() {
        return description;
    }
    public void setDescription(String description) {
        this.description = description;
    }
    public int getSeedCount() {
        return seedCount;
    }
    public void setSeedCount(int seedCount) {
        this.seedCount = seedCount;
    }
    public int getDownloadCount() {
        return downloadCount;
    }
    public void setDownloadCount(int downloadCount) {
        this.downloadCount = downloadCount;
    }

    /*
        * 重写toString方法，将资源信息以JSON字符串形式返回
     */
    @Override
    public String toString() {
        return "{" +
                "\"resourceId\":" + resourceId +
                ", \"name\":\"" + name + "\"" +
                ", \"size\":" + size +
                ", \"publishTime\":\"" + publishTime + "\"" +
                ", \"author\":\"" + author + "\"" +
                ", \"description\":\"" + description + "\"" +
                ", \"seedCount\":" + seedCount +
                ", \"downloadCount\":" + downloadCount +
                '}';
    }
}
