package com.pt.entity;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;

import java.time.LocalDateTime;

@Entity
public class TorrentStats {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private Long torrentId;       // 关联的种子ID
    private int seederCount;     // 当前做种人数
    private int leecherCount;    // 当前下载人数
    private int completedCount;  // 历史完成下载次数
    private LocalDateTime lastUpdated;

    // Getters and Setters

    public int getSeederCount() {
        return seederCount;
    }

    public void setSeederCount(int seederCount) {
        this.seederCount = seederCount;
    }

    public int getLeecherCount() {
        return leecherCount;
    }

    public void setLeecherCount(int leecherCount) {
        this.leecherCount = leecherCount;
    }

    public int getCompletedCount() {
        return completedCount;
    }

    public void setCompletedCount(int completedCount) {
        this.completedCount = completedCount;
    }

    public LocalDateTime getLastUpdated() {
        return lastUpdated;
    }

    public void setLastUpdated(LocalDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Long getTorrentId() {
        return torrentId;
    }

    public void setTorrentId(Long torrentId) {
        this.torrentId = torrentId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
