package com.pt.controller;

import com.pt.constant.Constants;
import com.pt.entity.Admin;
import com.pt.repository.AdminRepository;
import com.pt.service.AdminService;
import com.pt.utils.JWTUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.http.ResponseEntity;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/api/admin")
@CrossOrigin(origins = "*")
public class AdminController {

    @Autowired
    private AdminService adminService;

    @PostMapping("/login")
    public ResponseEntity<?> loginAdmin(@RequestParam("username") String username,
                                        @RequestParam("password") String password) {
        Map<String, Object> ans = new HashMap<>();
        Admin admin = adminService.findByUsernameAndPassword(username, password);
        if (admin != null) {
            ans.put("result", "Login successful");
            ans.put("token", JWTUtils.generateToken(username, Constants.UserRole.ADMIN, (int)1.2e8));
            return ResponseEntity.ok().body(ans);
        } else {
            ans.put("result", "Invalid username or password");
            return ResponseEntity.badRequest().body(ans);
        }
    }
}
