package com.pt.entity;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;

import java.time.LocalDateTime;

@Entity
public class Resource {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private int resourceId;

    private String name;
    private double size;

    private LocalDateTime publishTime;
    private String author;

    private String description;
    private byte[] torrentData;

    public Resource() {
    }

    public Resource(int resourceId, String name, double size, LocalDateTime publishTime, String author) {
        this.resourceId = resourceId;
        this.name = name;
        this.size = size;
        this.publishTime = publishTime;
        this.author = author;
    }

    public int getResourceId() {
        return resourceId;
    }
    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public double getSize() {
        return size;
    }
    public void setSize(double size) {
        this.size = size;
    }
    public LocalDateTime getPublishTime() {
        return publishTime;
    }
    public void setPublishTime(LocalDateTime publishTime) {
        this.publishTime = publishTime;
    }
    public String getAuthor() {
        return author;
    }
    public void setAuthor(String author) {
        this.author = author;
    }
    public String getDescription() {
        return description;
    }
    public void setDescription(String description) {
        this.description = description;
    }
    public byte[] getTorrentData() {
        return torrentData;
    }

    public void setTorrentData(byte[] torrentData) {
        this.torrentData = torrentData;
    }

    /*
        * 重写toString方法，将资源信息以JSON字符串形式返回
     */
    @Override
    public String toString() {
        return "{" +
                "\"resourceId\":" + resourceId +
                ", \"name\":\"" + name + "\"" +
                ", \"size\":" + size +
                ", \"publishTime\":\"" + publishTime + "\"" +
                ", \"author\":\"" + author + "\"" +
                ", \"description\":\"" + description + "\"" +
                '}';
    }
}
