package com.pt.repository;

import com.pt.entity.Resource;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

public interface ResourceRepository extends JpaRepository<Resource, Integer> {
    /**
     * Finds resources by their name containing the specified query, ignoring case.
     *
     * @param query the query string to search for in resource names
     * @return a list of resources whose names contain the query string
     */
    List<Resource> findByNameContainingIgnoreCase(String query);

    /**
     * Finds resources by their author.
     *
     * @param author the author's username
     * @return a list of resources authored by the specified user
     */
    List<Resource> findByAuthor(String author);
}
