package com.pt.constant;

public class Constants {

    public static final long DEFAULT_EXPIRE_TIME = 7 * 24 * 3600000;

    /*
        * 用户角色
        * 0: 普通用户
        * 1: 管理员
        * value既用来区分角色，也表示权限大小，value越大权限越大。
     */
    public enum UserRole {
        ADMIN(1),
        USER(0);

        private final int value;
        UserRole(int value) {
            this.value = value;
        }

        public int getValue() {
            return value;
        }
    }

    public enum UserLevel {
        NEWBIE(0),
        FRESH(1),
        SENIOR(2),
        MASTER(3);

        private final int value;
        UserLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return value;
        }
    }

    public static final double MIN_SHARE_RATIO_THRESHOLD = 0.5; // 最低共享率要求
    public static final long DOWNLOAD_EXEMPTION_BYTES = 20L * 1024L * 1024L * 1024L; // 20GB下载量豁免
}
