package com.pt.controller;

import com.pt.entity.TorrentStats;
import com.pt.service.TorrentStatsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/stats")
@CrossOrigin(origins = "*")
public class TorrentStatsController {

    @Autowired
    private TorrentStatsService statsService;

    // 1. 获取单个种子统计
    @GetMapping("/{torrentId}")
    public TorrentStats getStats(@PathVariable Long torrentId) {
        return statsService.getTorrentStats(torrentId);
    }

    // 2. 获取热门种子（做种人数TOP N）
    @GetMapping("/top-seeded")
    public List<TorrentStats> getTopSeeded(
            @RequestParam(defaultValue = "10") int limit) {
        return statsService.getTopSeededTorrents(limit);
    }

    // 3. 获取最近活跃种子
    @GetMapping("/recent-active")
    public List<TorrentStats> getRecentActive(
            @RequestParam(defaultValue = "10") int limit) {
        return statsService.getRecentActiveTorrents(limit);
    }

    // 4. 批量获取统计信息
    @PostMapping("/batch")
    public List<TorrentStats> getBatchStats(@RequestBody List<Long> torrentIds) {
        return statsService.getBatchStats(torrentIds);
    }
}