package com.pt.entity;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import org.hibernate.annotations.Formula;

import java.time.LocalDateTime;

@Entity
public class Comment {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private int commentId;

    private String content;
    private String writer;
    private int parentPost;

    private LocalDateTime publishDate;

    private Integer reviewer;

    public Comment() {
        publishDate = LocalDateTime.now();
    }

    public Comment(String content, String writer, int parentPost) {
        this.content = content;
        this.writer = writer;
        this.parentPost = parentPost;
        this.publishDate = LocalDateTime.now();
    }

    public int getCommentId() {
        return commentId;
    }

    public void setCommentId(int commentId) {
        this.commentId = commentId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getWriter() {
        return writer;
    }

    public void setWriter(String writer) {
        this.writer = writer;
    }

    public int getParentPost() {
        return parentPost;
    }

    public void setParentPost(int parentPost) {
        this.parentPost = parentPost;
    }

    public LocalDateTime getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(LocalDateTime publishDate) {
        this.publishDate = publishDate;
    }

    public Integer getReviewer() {
        return reviewer;
    }
    public void setReviewer(Integer reviewer) {
        this.reviewer = reviewer;
    }
}


